﻿using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.CancelAppointment
{
    public class MapToPatCancelAppointmentRequestStep:FilterBase<CancelAppointmentStateObject>
    {
        public override void Execute(CancelAppointmentStateObject state)
        {
            if (state.AppointmentType == AppointmentType.HOME_MOBILE)
                return;

            state.PatEcRequest = CancelAppointmentMapper.CancelAppointmentRequest(state, Side.Patient,Logger.Instance);
            var siteNum = state.PatEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_loginSiteCode;

            if (string.IsNullOrEmpty(state.PatUserDuz))
            {
                state.PatLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy, state.SAMLToken);
            }
            else
                state.PatEcRequest.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqproviderInfo.mcs_userId = state.PatUserDuz;
        }
    }
}
